/*
 * Decompiled with CFR 0.152.
 */
package jemu.settings;

import java.awt.EventQueue;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Properties;

public class RSettings {
    static int tried;
    private static File file;
    private static final RSettings instance;
    private final Properties props = new Properties();
    public static final String LOWER_ROM = "lower";
    public static final String UPPER_ROM_ = "upper_";
    public static final String UPPER_ROM_0 = "upper_0";
    public static final String UPPER_ROM_1 = "upper_1";
    public static final String UPPER_ROM_2 = "upper_2";
    public static final String UPPER_ROM_3 = "upper_3";
    public static final String UPPER_ROM_4 = "upper_4";
    public static final String UPPER_ROM_5 = "upper_5";
    public static final String UPPER_ROM_6 = "upper_6";
    public static final String UPPER_ROM_7 = "upper_7";
    public static final String UPPER_ROM_8 = "upper_8";
    public static final String UPPER_ROM_9 = "upper_9";
    public static final String UPPER_ROM_A = "upper_A";
    public static final String UPPER_ROM_B = "upper_B";
    public static final String UPPER_ROM_C = "upper_C";
    public static final String UPPER_ROM_D = "upper_D";
    public static final String UPPER_ROM_E = "upper_E";
    public static final String UPPER_ROM_F = "upper_F";
    public static final String UPPER_ROM_10 = "m_upper_10";
    public static final String UPPER_ROM_11 = "m_upper_11";
    public static final String UPPER_ROM_12 = "m_upper_12";
    public static final String UPPER_ROM_13 = "m_upper_13";
    public static final String UPPER_ROM_14 = "m_upper_14";
    public static final String UPPER_ROM_15 = "m_upper_15";
    public static final String UPPER_ROM_16 = "m_upper_16";
    public static final String UPPER_ROM_17 = "m_upper_17";
    public static final String UPPER_ROM_18 = "m_upper_18";
    public static final String UPPER_ROM_19 = "m_upper_19";
    public static final String UPPER_ROM_1A = "m_upper_1a";
    public static final String UPPER_ROM_1B = "m_upper_1b";
    public static final String UPPER_ROM_1C = "m_upper_1c";
    public static final String UPPER_ROM_1D = "m_upper_1d";
    public static final String UPPER_ROM_1E = "m_upper_1e";
    public static final String UPPER_ROM_1F = "m_upper_1f";

    public static void resetSettings() {
        while (file.exists()) {
            try {
                file.delete();
                Thread.sleep(100L);
                if (++tried <= 10) continue;
                System.out.println("Clearing the rom config failed...");
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    String command = "java -jar -Xms512m JavaCPC.jar";
                    Runtime.getRuntime().exec(command);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.exit(0);
            }
        });
    }

    private RSettings() {
        try {
            if (System.getSecurityManager() != null) {
                System.getSecurityManager().checkRead(file.getAbsolutePath());
            }
            this.props.loadFromXML(new FileInputStream(file));
            System.out.println("loaded " + this.props.size() + " rom settings");
        }
        catch (Throwable t) {
            this.CreateFirst();
            this.redo();
        }
    }

    private void redo() {
        try {
            if (System.getSecurityManager() != null) {
                System.getSecurityManager().checkRead(file.getAbsolutePath());
            }
            this.props.loadFromXML(new FileInputStream(file));
            System.out.println("loaded " + this.props.size() + " rom settings");
        }
        catch (Throwable t) {
            System.out.println("can't load user settings (" + t.getMessage() + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void CreateFirst() {
        String name = "romsettings.xml";
        byte[] buffer = null;
        int offs = 0;
        try (InputStream stream = null;){
            int read;
            int size;
            InputStream is;
            stream = is = this.getClass().getResourceAsStream(name);
            buffer = new byte[size];
            for (size = is.available(); size > 0; size -= read) {
                read = stream.read(buffer, offs, size);
                if (read == -1) {
                    break;
                }
                offs += read;
            }
        }
        catch (Exception e) {
            System.err.println("File not found...");
        }
        if (buffer != null) {
            try {
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
                bos.write(buffer);
                bos.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        String value = RSettings.instance.props.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return value.equals("true");
    }

    public static void setBoolean(String key, boolean value) {
        RSettings.instance.props.setProperty(key, value ? "true" : "false");
        RSettings.save();
    }

    public static String get(String key, String defaultValue) {
        String value = RSettings.instance.props.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static void set(String key, String value) {
        if (value.equals(RSettings.get(key, null))) {
            return;
        }
        RSettings.instance.props.setProperty(key, value);
        RSettings.save();
    }

    private static void save() {
        try {
            File f = new File(System.getProperty("user.home"), "JavaCPC");
            f.mkdir();
            if (System.getSecurityManager() != null) {
                System.getSecurityManager().checkWrite(file.getAbsolutePath());
            }
            FileOutputStream fos = new FileOutputStream(file);
            RSettings.instance.props.storeToXML(fos, "[ROM - Settings]");
            fos.close();
        }
        catch (Throwable t) {
            System.out.println("can't save user settings (" + t.getMessage() + ")");
        }
    }

    static {
        file = new File(System.getProperty("user.home"), "/JavaCPC/romsettings.xml");
        instance = new RSettings();
    }
}

